#!/bin/sh
echo root::0:0:root,,,:/root:/bin/sh >/etc/passwd
/usr/sbin/inetd &

LOG_FILE=/mnt/ubi_boot/revert_stock_ujb.log
SDA1_LOG_FILE=/mnt/sda1/revert_stock_ujb.log
FLAG_BDPPROG=/mnt/ubi_boot/.bdpprog_stock
SUCCESS_MSG="Undo JB successfuly done"


log () {
	echo "$1" >>${LOG_FILE} 2>&1
}

End_of_installation () {
	[ -f /mnt/ubi_boot/bdpprog ] && log "Remove ubiboot stock bdpprog" && rm -f /mnt/ubi_boot/bdpprog
	[ -x /mnt/ubi_boot/bdpprog.bk ] && log "Restore initial ubiboot bdpprog" && mv /mnt/ubi_boot/bdpprog.bk /mnt/ubi_boot/bdpprog
	log "Remove ubiboot stock bdpprog flag installation"
	rm -f ${FLAG_BDPPROG}
	log "$1"
	mv ${LOG_FILE} ${SDA1_LOG_FILE}
	sync
	sync
}

[ -f /mnt/sda1/UDP20X.bin ] && udp20x=UDP20X.bin && bdpprog_stk=bdpprog_us
[ -f /mnt/sda1/UDP20XRU.bin ] && udp20x=UDP20XRU.bin && bdpprog_stk=bdpprog_ru
[ -f /mnt/sda1/UDP20XEU.bin ] && udp20x=UDP20XEU.bin && bdpprog_stk=bdpprog_eu
[ -f /mnt/sda1/UDP20XAU.bin ] && udp20x=UDP20XAU.bin && bdpprog_stk=bdpprog_au
[ -f /mnt/sda1/UDP20XCN.bin ] && udp20x=UDP20XCN.bin && bdpprog_stk=bdpprog_cn
[ -f /mnt/sda1/UDP20XJP.bin ] && udp20x=UDP20XJP.bin && bdpprog_stk=bdpprog_jp
[ -f /mnt/sda1/UDP20XTW.bin ] && udp20x=UDP20XTW.bin && bdpprog_stk=bdpprog_tw


if [ -s ${FLAG_BDPPROG} ]; then
	EOF_UPG=$(cat ${FLAG_BDPPROG})
	[ "${EOF_UPG}" == "SUCCESS" ] &&  End_of_installation "${SUCCESS_MSG}"
	exit
fi

[ ! -f /usr/local/bin/bdpprog.1 ] && exit


if [ -f ${SDA1_LOG_FILE} ] && [ $(cat ${SDA1_LOG_FILE}|grep -c "${SUCCESS_MSG}") -ne 0 ]; then
	WARNING="Error : Undo jailbreak already successfully done, please remove this log file to run again the AutoScript"
	[ $(cat ${SDA1_LOG_FILE}|grep -c "${WARNING}") -eq 0 ] && echo "${WARNING}" >> ${SDA1_LOG_FILE} 2>&1 && sync && sync
	exit
fi

[ ! -f ${LOG_FILE} ] && touch ${LOG_FILE}
if [ ! -f "/mnt/sda1/${udp20x}" ] || [ ! -f "/mnt/sda1/${bdpprog_stk}" ]; then
	log "Error : missing prerequisite file(s)"
	mv ${LOG_FILE} ${SDA1_LOG_FILE}
	sync
	sync
	exit
fi


if [ ! -f ${FLAG_BDPPROG} ]; then
	if [ -f /mnt/ubi_boot/bdpprog ]; then 
		log "Backup current ubiboot bdpprog"
		mv /mnt/ubi_boot/bdpprog /mnt/ubi_boot/bdpprog.bk
	fi
	log "Install stock ubiboot bdpprog"
	cp -f "/mnt/sda1/${bdpprog_stk}" /mnt/ubi_boot/bdpprog
	chmod +x /mnt/ubi_boot/bdpprog
	log "Flag Ubiboot stock bdpprog"
	touch ${FLAG_BDPPROG}
	sync
	sync
	sleep 1s
	reboot -f
fi


log "Revert to stock FW"

echo -e "drv.ir.rx.sq 0x10000\nquit" | cliprog	#Invalid command, the screen returns to normal
echo -e "drv.ir.rx.sq 0x8f001\nquit" | cliprog	#SETUP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x3f002\nquit" | cliprog	#UP
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
echo -e "drv.ir.rx.sq 0x3f003\nquit" | cliprog	#Down
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
sleep 5s
if [ -d /tmp/UPG ]; then
	sleep 10s
	if [ -f /tmp/UPG/VER.ini ]; then
		echo -e "drv.ir.rx.sq 0x3f000\nquit" | cliprog	#Left
		echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select

		echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
		sleep 1s
		echo "SUCCESS" > ${FLAG_BDPPROG}
		sync
		sync
		exit
	fi
fi
echo -e "drv.ir.rx.sq 0x4f000\nquit" | cliprog	#Select
log "Error : UGD failure : invalid ${bdpprog_stk} or ${udp20x}"
End_of_installation "Error : Undo JB failed, back to current Firmware"
echo -e "drv.ir.rx.sq 0xaf000\nquit" | cliprog	#Open
sleep 3s
echo -e "drv.ir.rx.sq 0x8f000\nquit" | cliprog	#Power Off

